<?php
namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

use AfricasTalking\SDK\AfricasTalking;

class NotificationsController extends AbstractController
{
    /**
     * @Route("/notifications", name="notifications")
     */
    public function index(): Response
    {
        return $this->render('notifications/index.html.twig', [
            'controller_name' => 'NotificationsController',
        ]);
    }

     /**
     * Send a new sms
     * @param Request $request
     * @Route("/sms", methods={"GET","POST"})
     * @return Response
     */
    public function sendsmsnotification(Request $request)
    {

        ////////////////////////////////
        //Celcom africa configurations//
        ////////////////////////////////

        $content = json_decode($request->getContent(), true);
        $apiKey = $content['smsApiKey'];

        $url = 'https://isms.celcomafrica.com/api/services/sendsms/';
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

        $curl_post_data = array(

        'partnerID' => '309',
        'apikey' => $apiKey,
        'mobile' => $content['smsPhoneNo'],
        'message' => $content['smsMessage'],
        'shortcode' => 'Besma Sacco',
        'pass_type' => 'plain',
        );

        $data_string = json_encode($curl_post_data);

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

        $curl_response = curl_exec($curl);
        return new Response(json_encode($curl_response));


        //Afrika is talking configurations
        /*
        $content = json_decode($request->getContent(), true);
           $username = 'NewChetro';
             $apiKey = $content['smsApiKey'];
                 $AT = new AfricasTalking($username, $apiKey);
                $sms = $AT->sms();
             $result = $sms->send([
                'to' => $content['smsPhoneNo'],
           'message' => $content['smsMessage'],
              'from' => 'ChetroSacco'
        ]);
        return new Response(json_encode($result));
        */

    }

}
