<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TAppraiseeAssigningsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_appraisee_assignings:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_appraisee_assignings:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "supervisor": "exact", "appraisee": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TAppraiseeAssigningsRepository::class)
 */

class TAppraiseeAssignings
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_appraisee_assignings:read", "t_appraisee_assignings:write" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyStaffMembers::class, inversedBy="tAppraiseeAssignings")
     * @Groups({ "t_appraisee_assignings:read", "t_appraisee_assignings:write" })
     */
    private $supervisor;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyStaffMembers::class, inversedBy="tAppraiseeAssignings")
     * @Groups({ "t_appraisee_assignings:read", "t_appraisee_assignings:write" })
     */
    private $appraisee;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSupervisor(): ?TCountyStaffMembers
    {
        return $this->supervisor;
    }

    public function setSupervisor(?TCountyStaffMembers $supervisor): self
    {
        $this->supervisor = $supervisor;

        return $this;
    }

    public function getAppraisee(): ?TCountyStaffMembers
    {
        return $this->appraisee;
    }

    public function setAppraisee(?TCountyStaffMembers $appraisee): self
    {
        $this->appraisee = $appraisee;

        return $this;
    }

}
