<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TConstituenciesRepository;
use Doctrine\ORM\Mapping as ORM;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_constituencies:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_constituencies:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TConstituenciesRepository::class)
 */

class TConstituencies
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_constituencies:read", "t_constituencies:write", "t_county_departments_adp_projects:read", "t_county_wards:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_constituencies:read", "t_constituencies:write", "t_county_wards:read", "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:read" })
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity=TCountyWards::class, mappedBy="constituency")
     */
    private $tCountyWards;

    /**
     * @ORM\OneToMany(targetEntity=TCountyDepartmentsAdpProjects::class, mappedBy="constituency")
     */
    private $tCountyDepartmentsAdpProjects;

    public function __construct()
    {
        $this->tCountyWards = new ArrayCollection();
        $this->tCountyDepartmentsAdpProjects = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Collection|TCountyWards[]
     */
    public function getTCountyWards(): Collection
    {
        return $this->tCountyWards;
    }

    public function addTCountyWard(TCountyWards $tCountyWard): self
    {
        if (!$this->tCountyWards->contains($tCountyWard)) {
            $this->tCountyWards[] = $tCountyWard;
            $tCountyWard->setConstituency($this);
        }

        return $this;
    }

    public function removeTCountyWard(TCountyWards $tCountyWard): self
    {
        if ($this->tCountyWards->removeElement($tCountyWard)) {
            // set the owning side to null (unless already changed)
            if ($tCountyWard->getConstituency() === $this) {
                $tCountyWard->setConstituency(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCountyDepartmentsAdpProjects[]
     */
    public function getTCountyDepartmentsAdpProjects(): Collection
    {
        return $this->tCountyDepartmentsAdpProjects;
    }

    public function addTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if (!$this->tCountyDepartmentsAdpProjects->contains($tCountyDepartmentsAdpProject)) {
            $this->tCountyDepartmentsAdpProjects[] = $tCountyDepartmentsAdpProject;
            $tCountyDepartmentsAdpProject->setConstituency($this);
        }

        return $this;
    }

    public function removeTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if ($this->tCountyDepartmentsAdpProjects->removeElement($tCountyDepartmentsAdpProject)) {
            // set the owning side to null (unless already changed)
            if ($tCountyDepartmentsAdpProject->getConstituency() === $this) {
                $tCountyDepartmentsAdpProject->setConstituency(null);
            }
        }

        return $this;
    }
}
