<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCosRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_cos:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_cos:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "department": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCosRepository::class)
 */

class TCos
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_cos:read", "t_cos:write", "t_pcs:read" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyStaffMembers::class, inversedBy="tCos")
     * @Groups({ "t_cos:read", "t_cos:write", "t_pcs:read" })
     */
    private $staffMember;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tCos")
     * @Groups({ "t_cos:read", "t_cos:write", "t_pcs:read" })
     */
    private $sector;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_cos:read", "t_cos:write" })
     */
    private $currentStaff;

    /**
     * @ORM\OneToMany(targetEntity=TPcs::class, mappedBy="coSignsOwnPc")
     */
    private $tPcs;

    /**
     * @ORM\OneToMany(targetEntity=TPcs::class, mappedBy="coWithDir")
     */
    private $coWithDir;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyDepartments::class, inversedBy="tCos")
     * @Groups({ "t_cos:read", "t_cos:write", "t_pcs:read" })
     */
    private $department;

    public function __construct()
    {
        $this->tPcs = new ArrayCollection();
        $this->coWithDir = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStaffMember(): ?TCountyStaffMembers
    {
        return $this->staffMember;
    }

    public function setStaffMember(?TCountyStaffMembers $staffMember): self
    {
        $this->staffMember = $staffMember;

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }

    public function getCurrentStaff(): ?string
    {
        return $this->currentStaff;
    }

    public function setCurrentStaff(?string $currentStaff): self
    {
        $this->currentStaff = $currentStaff;

        return $this;
    }

    /**
     * @return Collection|TPcs[]
     */
    public function getTPcs(): Collection
    {
        return $this->tPcs;
    }

    public function addTPc(TPcs $tPc): self
    {
        if (!$this->tPcs->contains($tPc)) {
            $this->tPcs[] = $tPc;
            $tPc->setCoSignsOwnPc($this);
        }

        return $this;
    }

    public function removeTPc(TPcs $tPc): self
    {
        if ($this->tPcs->removeElement($tPc)) {
            // set the owning side to null (unless already changed)
            if ($tPc->getCoSignsOwnPc() === $this) {
                $tPc->setCoSignsOwnPc(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TPcs[]
     */
    public function getCoWithDir(): Collection
    {
        return $this->coWithDir;
    }

    public function addCoWithDir(TPcs $coWithDir): self
    {
        if (!$this->coWithDir->contains($coWithDir)) {
            $this->coWithDir[] = $coWithDir;
            $coWithDir->setCoWithDir($this);
        }

        return $this;
    }

    public function removeCoWithDir(TPcs $coWithDir): self
    {
        if ($this->coWithDir->removeElement($coWithDir)) {
            // set the owning side to null (unless already changed)
            if ($coWithDir->getCoWithDir() === $this) {
                $coWithDir->setCoWithDir(null);
            }
        }

        return $this;
    }

    public function getDepartment(): ?TCountyDepartments
    {
        return $this->department;
    }

    public function setDepartment(?TCountyDepartments $department): self
    {
        $this->department = $department;

        return $this;
    }
}
