<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCountyDepartmentsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_county_departments:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_county_departments:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "sector": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCountyDepartmentsRepository::class)
 */

class TCountyDepartments
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_county_departments:read", "t_county_departments:write", "t_directorates:read", "t_cos:read", "t_directors:read", "t_county_departments_adp_projects:read", "t_county_sectors:read", "t_county_staff_members:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_county_departments:read", "t_county_departments:write", "t_directorates:read", "t_cos:read", "t_directors:read", "t_county_departments_adp_projects:read", "t_county_sectors:read", "t_pcs:read", "t_county_staff_members:read" })
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_county_departments:read", "t_county_departments:write" })
     */
    private $code;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_county_departments:read", "t_county_departments:write" })
     */
    private $alias;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tCountyDepartments")
     * @Groups({ "t_county_departments:read", "t_county_departments:write" })
     */
    private $sector;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_county_departments:read", "t_county_departments:write" })
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TDirectorates::class, mappedBy="department")
     */
    private $tDirectorates;

    /**
     * @ORM\OneToMany(targetEntity=TCos::class, mappedBy="department")
     */
    private $tCos;

    /**
     * @ORM\OneToMany(targetEntity=TDirectors::class, mappedBy="department")
     */
    private $tDirectors;

    /**
     * @ORM\OneToMany(targetEntity=TCountyDepartmentsAdpProjects::class, mappedBy="department")
     * @Groups({ "t_county_departments:read", "t_county_departments:write" })
     */
    private $tCountyDepartmentsAdpProjects;

    /**
     * @ORM\OneToMany(targetEntity=TMilestones::class, mappedBy="department")
     */
    private $tMilestones;

    /**
     * @ORM\OneToMany(targetEntity=TCountyStaffMembers::class, mappedBy="department")
     */
    private $tCountyStaffMembers;

    public function __construct()
    {
        $this->tDirectorates = new ArrayCollection();
        $this->tCos = new ArrayCollection();
        $this->tDirectors = new ArrayCollection();
        $this->tCountyDepartmentsAdpProjects = new ArrayCollection();
        $this->tMilestones = new ArrayCollection();
        $this->tCountyStaffMembers = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): self
    {
        $this->code = $code;

        return $this;
    }

    public function getAlias(): ?string
    {
        return $this->alias;
    }

    public function setAlias(?string $alias): self
    {
        $this->alias = $alias;

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TDirectorates[]
     */
    public function getTDirectorates(): Collection
    {
        return $this->tDirectorates;
    }

    public function addTDirectorate(TDirectorates $tDirectorate): self
    {
        if (!$this->tDirectorates->contains($tDirectorate)) {
            $this->tDirectorates[] = $tDirectorate;
            $tDirectorate->setDepartment($this);
        }

        return $this;
    }

    public function removeTDirectorate(TDirectorates $tDirectorate): self
    {
        if ($this->tDirectorates->removeElement($tDirectorate)) {
            // set the owning side to null (unless already changed)
            if ($tDirectorate->getDepartment() === $this) {
                $tDirectorate->setDepartment(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCos[]
     */
    public function getTCos(): Collection
    {
        return $this->tCos;
    }

    public function addTCo(TCos $tCo): self
    {
        if (!$this->tCos->contains($tCo)) {
            $this->tCos[] = $tCo;
            $tCo->setDepartment($this);
        }

        return $this;
    }

    public function removeTCo(TCos $tCo): self
    {
        if ($this->tCos->removeElement($tCo)) {
            // set the owning side to null (unless already changed)
            if ($tCo->getDepartment() === $this) {
                $tCo->setDepartment(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TDirectors[]
     */
    public function getTDirectors(): Collection
    {
        return $this->tDirectors;
    }

    public function addTDirector(TDirectors $tDirector): self
    {
        if (!$this->tDirectors->contains($tDirector)) {
            $this->tDirectors[] = $tDirector;
            $tDirector->setDepartment($this);
        }

        return $this;
    }

    public function removeTDirector(TDirectors $tDirector): self
    {
        if ($this->tDirectors->removeElement($tDirector)) {
            // set the owning side to null (unless already changed)
            if ($tDirector->getDepartment() === $this) {
                $tDirector->setDepartment(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCountyDepartmentsAdpProjects[]
     */
    public function getTCountyDepartmentsAdpProjects(): Collection
    {
        return $this->tCountyDepartmentsAdpProjects;
    }

    public function addTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if (!$this->tCountyDepartmentsAdpProjects->contains($tCountyDepartmentsAdpProject)) {
            $this->tCountyDepartmentsAdpProjects[] = $tCountyDepartmentsAdpProject;
            $tCountyDepartmentsAdpProject->setDepartment($this);
        }

        return $this;
    }

    public function removeTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if ($this->tCountyDepartmentsAdpProjects->removeElement($tCountyDepartmentsAdpProject)) {
            // set the owning side to null (unless already changed)
            if ($tCountyDepartmentsAdpProject->getDepartment() === $this) {
                $tCountyDepartmentsAdpProject->setDepartment(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TMilestones[]
     */
    public function getTMilestones(): Collection
    {
        return $this->tMilestones;
    }

    public function addTMilestone(TMilestones $tMilestone): self
    {
        if (!$this->tMilestones->contains($tMilestone)) {
            $this->tMilestones[] = $tMilestone;
            $tMilestone->setDepartment($this);
        }

        return $this;
    }

    public function removeTMilestone(TMilestones $tMilestone): self
    {
        if ($this->tMilestones->removeElement($tMilestone)) {
            // set the owning side to null (unless already changed)
            if ($tMilestone->getDepartment() === $this) {
                $tMilestone->setDepartment(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCountyStaffMembers[]
     */
    public function getTCountyStaffMembers(): Collection
    {
        return $this->tCountyStaffMembers;
    }

    public function addTCountyStaffMember(TCountyStaffMembers $tCountyStaffMember): self
    {
        if (!$this->tCountyStaffMembers->contains($tCountyStaffMember)) {
            $this->tCountyStaffMembers[] = $tCountyStaffMember;
            $tCountyStaffMember->setDepartment($this);
        }

        return $this;
    }

    public function removeTCountyStaffMember(TCountyStaffMembers $tCountyStaffMember): self
    {
        if ($this->tCountyStaffMembers->removeElement($tCountyStaffMember)) {
            // set the owning side to null (unless already changed)
            if ($tCountyStaffMember->getDepartment() === $this) {
                $tCountyStaffMember->setDepartment(null);
            }
        }

        return $this;
    }


}
