<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCountyWardsRepository;
use Doctrine\ORM\Mapping as ORM;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_county_wards:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_county_wards:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCountyWardsRepository::class)
 */

class TCountyWards
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_county_wards:read", "t_county_wards:write", "t_county_departments_adp_projects:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_county_wards:read", "t_county_wards:write", "t_county_departments_adp_projects:read" })
     */
    private $name;

    /**
     * @ORM\ManyToOne(targetEntity=TConstituencies::class, inversedBy="tCountyWards")
     * @Groups({ "t_county_wards:read", "t_county_wards:write" })
     */
    private $constituency;

    /**
     * @ORM\OneToMany(targetEntity=TCountyDepartmentsAdpProjects::class, mappedBy="ward")
     */
    private $tCountyDepartmentsAdpProjects;

    public function __construct()
    {
        $this->tCountyDepartmentsAdpProjects = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getConstituency(): ?TConstituencies
    {
        return $this->constituency;
    }

    public function setConstituency(?TConstituencies $constituency): self
    {
        $this->constituency = $constituency;

        return $this;
    }

    /**
     * @return Collection|TCountyDepartmentsAdpProjects[]
     */
    public function getTCountyDepartmentsAdpProjects(): Collection
    {
        return $this->tCountyDepartmentsAdpProjects;
    }

    public function addTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if (!$this->tCountyDepartmentsAdpProjects->contains($tCountyDepartmentsAdpProject)) {
            $this->tCountyDepartmentsAdpProjects[] = $tCountyDepartmentsAdpProject;
            $tCountyDepartmentsAdpProject->setWard($this);
        }

        return $this;
    }

    public function removeTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if ($this->tCountyDepartmentsAdpProjects->removeElement($tCountyDepartmentsAdpProject)) {
            // set the owning side to null (unless already changed)
            if ($tCountyDepartmentsAdpProject->getWard() === $this) {
                $tCountyDepartmentsAdpProject->setWard(null);
            }
        }

        return $this;
    }
}
