<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TDirectorateObjectivesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_directorate_objectives:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_directorate_objectives:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "sector": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TDirectorateObjectivesRepository::class)
 */

class TDirectorateObjectives
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_directorate_objectives:read", "t_directorate_objectives:write", "t_projects:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_directorate_objectives:read", "t_directorate_objectives:write" })
     */
    private $objectiveCode;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_directorate_objectives:read", "t_directorate_objectives:write", "t_projects:read" })
     */
    private $objectiveName;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_directorate_objectives:read", "t_directorate_objectives:write" })
     */
    private $weight;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_directorate_objectives:read", "t_directorate_objectives:write" })
     */
    private $budgetAllocated;

    /**
     * @ORM\ManyToOne(targetEntity=TFinancialYears::class, inversedBy="tDirectorateObjectives")
     * @Groups({ "t_directorate_objectives:read", "t_directorate_objectives:write" })
     */
    private $financialYear;

    /**
     * @ORM\ManyToOne(targetEntity=TSectorObjectives::class, inversedBy="tDirectorateObjectives")
     * @Groups({ "t_directorate_objectives:read", "t_directorate_objectives:write" })
     */
    private $sectorObjective;

    /**
     * @ORM\ManyToOne(targetEntity=TDirectorates::class, inversedBy="tDirectorateObjectives")
     * @Groups({ "t_directorate_objectives:read", "t_directorate_objectives:write" })
     */
    private $directorate;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tDirectorateObjectives")
     * @Groups({ "t_directorate_objectives:read", "t_directorate_objectives:write" })
     */
    private $sector;

    public function __construct()
    {
        
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getObjectiveCode(): ?string
    {
        return $this->objectiveCode;
    }

    public function setObjectiveCode(?string $objectiveCode): self
    {
        $this->objectiveCode = $objectiveCode;

        return $this;
    }

    public function getObjectiveName(): ?string
    {
        return $this->objectiveName;
    }

    public function setObjectiveName(?string $objectiveName): self
    {
        $this->objectiveName = $objectiveName;

        return $this;
    }

    public function getWeight(): ?string
    {
        return $this->weight;
    }

    public function setWeight(?string $weight): self
    {
        $this->weight = $weight;

        return $this;
    }

    public function getBudgetAllocated(): ?string
    {
        return $this->budgetAllocated;
    }

    public function setBudgetAllocated(?string $budgetAllocated): self
    {
        $this->budgetAllocated = $budgetAllocated;

        return $this;
    }

    public function getFinancialYear(): ?TFinancialYears
    {
        return $this->financialYear;
    }

    public function setFinancialYear(?TFinancialYears $financialYear): self
    {
        $this->financialYear = $financialYear;

        return $this;
    }

    public function getSectorObjective(): ?TSectorObjectives
    {
        return $this->sectorObjective;
    }

    public function setSectorObjective(?TSectorObjectives $sectorObjective): self
    {
        $this->sectorObjective = $sectorObjective;

        return $this;
    }

    public function getDirectorate(): ?TDirectorates
    {
        return $this->directorate;
    }

    public function setDirectorate(?TDirectorates $directorate): self
    {
        $this->directorate = $directorate;

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }

}
