<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TDirectoratesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_directorates:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_directorates:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "sector": "exact", "department": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TDirectoratesRepository::class)
 */

class TDirectorates
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_directorates:read", "t_directorates:write", "t_appraisals:read", "t_directors:read", "t_county_sectors:read", "t_county_departments:read", "t_county_departments_adp_projects:read", "t_county_staff_members:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_directorates:read", "t_directorates:write", "t_appraisals:read", "t_directors:read", "t_county_departments:read", "t_county_departments_adp_projects:read", "t_pcs:read", "t_county_staff_members:read" })
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_directorates:read", "t_directorates:write" })
     */
    private $code;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_directorates:read", "t_directorates:write" })
     */
    private $alias;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_directorates:read", "t_directorates:write" })
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TDirectorateObjectives::class, mappedBy="directorate")
     * @Groups({ "t_directorates:read", "t_directorates:write" })
     */
    private $tDirectorateObjectives;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tDirectorates")
     * @Groups({ "t_directorates:read", "t_directorates:write" })
     */
    private $sector;

    /**
     * @ORM\OneToMany(targetEntity=TDirectors::class, mappedBy="directorate")
     * @Groups({ "t_directorates:read", "t_directorates:write" })
     */
    private $tDirectors;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyDepartments::class, inversedBy="tDirectorates")
     * @Groups({ "t_directorates:read", "t_directorates:write" })
     */
    private $department;

    /**
     * @ORM\OneToMany(targetEntity=TMilestones::class, mappedBy="directorate")
     */
    private $tMilestones;

    /**
     * @ORM\OneToMany(targetEntity=TAppraisals::class, mappedBy="directorate")
     */
    private $tAppraisals;

    /**
     * @ORM\OneToMany(targetEntity=TCountyDepartmentsAdpProjects::class, mappedBy="directorate")
     */
    private $tCountyDepartmentsAdpProjects;

    /**
     * @ORM\OneToMany(targetEntity=TCountyStaffMembers::class, mappedBy="directorate")
     */
    private $tCountyStaffMembers;

    public function __construct()
    {
        $this->tDirectors = new ArrayCollection();
        $this->tMilestones = new ArrayCollection();
        $this->tAppraisals = new ArrayCollection();
        $this->tCountyDepartmentsAdpProjects = new ArrayCollection();
        $this->tCountyStaffMembers = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): self
    {
        $this->code = $code;

        return $this;
    }

    public function getAlias(): ?string
    {
        return $this->alias;
    }

    public function setAlias(?string $alias): self
    {
        $this->alias = $alias;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TDirectorateObjectives[]
     */
    public function getTDirectorateObjectives(): Collection
    {
        return $this->tDirectorateObjectives;
    }

    public function addTDirectorateObjective(TDirectorateObjectives $tDirectorateObjective): self
    {
        if (!$this->tDirectorateObjectives->contains($tDirectorateObjective)) {
            $this->tDirectorateObjectives[] = $tDirectorateObjective;
            $tDirectorateObjective->setDirectorate($this);
        }

        return $this;
    }

    public function removeTDirectorateObjective(TDirectorateObjectives $tDirectorateObjective): self
    {
        if ($this->tDirectorateObjectives->removeElement($tDirectorateObjective)) {
            // set the owning side to null (unless already changed)
            if ($tDirectorateObjective->getDirectorate() === $this) {
                $tDirectorateObjective->setDirectorate(null);
            }
        }

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }

    /**
     * @return Collection|TDirectors[]
     */
    public function getTDirectors(): Collection
    {
        return $this->tDirectors;
    }

    public function addTDirector(TDirectors $tDirector): self
    {
        if (!$this->tDirectors->contains($tDirector)) {
            $this->tDirectors[] = $tDirector;
            $tDirector->setDirectorate($this);
        }

        return $this;
    }

    public function removeTDirector(TDirectors $tDirector): self
    {
        if ($this->tDirectors->removeElement($tDirector)) {
            // set the owning side to null (unless already changed)
            if ($tDirector->getDirectorate() === $this) {
                $tDirector->setDirectorate(null);
            }
        }

        return $this;
    }

    public function getDepartment(): ?TCountyDepartments
    {
        return $this->department;
    }

    public function setDepartment(?TCountyDepartments $department): self
    {
        $this->department = $department;

        return $this;
    }

    /**
     * @return Collection|TMilestones[]
     */
    public function getTMilestones(): Collection
    {
        return $this->tMilestones;
    }

    public function addTMilestone(TMilestones $tMilestone): self
    {
        if (!$this->tMilestones->contains($tMilestone)) {
            $this->tMilestones[] = $tMilestone;
            $tMilestone->setDirectorate($this);
        }

        return $this;
    }

    public function removeTMilestone(TMilestones $tMilestone): self
    {
        if ($this->tMilestones->removeElement($tMilestone)) {
            // set the owning side to null (unless already changed)
            if ($tMilestone->getDirectorate() === $this) {
                $tMilestone->setDirectorate(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAppraisals[]
     */
    public function getTAppraisals(): Collection
    {
        return $this->tAppraisals;
    }

    public function addTAppraisal(TAppraisals $tAppraisal): self
    {
        if (!$this->tAppraisals->contains($tAppraisal)) {
            $this->tAppraisals[] = $tAppraisal;
            $tAppraisal->setDirectorate($this);
        }

        return $this;
    }

    public function removeTAppraisal(TAppraisals $tAppraisal): self
    {
        if ($this->tAppraisals->removeElement($tAppraisal)) {
            // set the owning side to null (unless already changed)
            if ($tAppraisal->getDirectorate() === $this) {
                $tAppraisal->setDirectorate(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCountyDepartmentsAdpProjects[]
     */
    public function getTCountyDepartmentsAdpProjects(): Collection
    {
        return $this->tCountyDepartmentsAdpProjects;
    }

    public function addTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if (!$this->tCountyDepartmentsAdpProjects->contains($tCountyDepartmentsAdpProject)) {
            $this->tCountyDepartmentsAdpProjects[] = $tCountyDepartmentsAdpProject;
            $tCountyDepartmentsAdpProject->setDirectorate($this);
        }

        return $this;
    }

    public function removeTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if ($this->tCountyDepartmentsAdpProjects->removeElement($tCountyDepartmentsAdpProject)) {
            // set the owning side to null (unless already changed)
            if ($tCountyDepartmentsAdpProject->getDirectorate() === $this) {
                $tCountyDepartmentsAdpProject->setDirectorate(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCountyStaffMembers[]
     */
    public function getTCountyStaffMembers(): Collection
    {
        return $this->tCountyStaffMembers;
    }

    public function addTCountyStaffMember(TCountyStaffMembers $tCountyStaffMember): self
    {
        if (!$this->tCountyStaffMembers->contains($tCountyStaffMember)) {
            $this->tCountyStaffMembers[] = $tCountyStaffMember;
            $tCountyStaffMember->setDirectorate($this);
        }

        return $this;
    }

    public function removeTCountyStaffMember(TCountyStaffMembers $tCountyStaffMember): self
    {
        if ($this->tCountyStaffMembers->removeElement($tCountyStaffMember)) {
            // set the owning side to null (unless already changed)
            if ($tCountyStaffMember->getDirectorate() === $this) {
                $tCountyStaffMember->setDirectorate(null);
            }
        }

        return $this;
    }

   
}
