<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TDirectorsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_directors:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_directors:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "directorate": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TDirectorsRepository::class)
 */

class TDirectors
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_directors:read", "t_directors:write", "t_pcs:read", "t_appraisals:read" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TDirectorates::class, inversedBy="tDirectors")
     * @Groups({ "t_directors:read", "t_directors:write", "t_pcs:read" })
     */
    private $directorate;

    /**
     * @ORM\OneToMany(targetEntity=TPcs::class, mappedBy="dirSignsOwnPc")
     */
    private $tPcs;

    /**
     * @ORM\OneToMany(targetEntity=TAppraisals::class, mappedBy="director")
     */
    private $tAppraisals;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyStaffMembers::class, inversedBy="tDirectors")
     * @Groups({ "t_directors:read", "t_directors:write", "t_pcs:read" })
     */
    private $staffMember;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({ "t_directors:read", "t_directors:write" })
     */
    private $currentStaff;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tDirectors")
     * @Groups({ "t_directors:read", "t_directors:write" })
     */
    private $sector;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyDepartments::class, inversedBy="tDirectors")
     * @Groups({ "t_directors:read", "t_directors:write" })
     */
    private $department;

    public function __construct()
    {
        $this->tPcs = new ArrayCollection();
        $this->tAppraisals = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDirectorate(): ?TDirectorates
    {
        return $this->directorate;
    }

    public function setDirectorate(?TDirectorates $directorate): self
    {
        $this->directorate = $directorate;

        return $this;
    }

    /**
     * @return Collection|TPcs[]
     */
    public function getTPcs(): Collection
    {
        return $this->tPcs;
    }

    public function addTPc(TPcs $tPc): self
    {
        if (!$this->tPcs->contains($tPc)) {
            $this->tPcs[] = $tPc;
            $tPc->setDirSignsOwnPc($this);
        }

        return $this;
    }

    public function removeTPc(TPcs $tPc): self
    {
        if ($this->tPcs->removeElement($tPc)) {
            // set the owning side to null (unless already changed)
            if ($tPc->getDirSignsOwnPc() === $this) {
                $tPc->setDirSignsOwnPc(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAppraisals[]
     */
    public function getTAppraisals(): Collection
    {
        return $this->tAppraisals;
    }

    public function addTAppraisal(TAppraisals $tAppraisal): self
    {
        if (!$this->tAppraisals->contains($tAppraisal)) {
            $this->tAppraisals[] = $tAppraisal;
            $tAppraisal->setDirector($this);
        }

        return $this;
    }

    public function removeTAppraisal(TAppraisals $tAppraisal): self
    {
        if ($this->tAppraisals->removeElement($tAppraisal)) {
            // set the owning side to null (unless already changed)
            if ($tAppraisal->getDirector() === $this) {
                $tAppraisal->setDirector(null);
            }
        }

        return $this;
    }

    public function getStaffMember(): ?TCountyStaffMembers
    {
        return $this->staffMember;
    }

    public function setStaffMember(?TCountyStaffMembers $staffMember): self
    {
        $this->staffMember = $staffMember;

        return $this;
    }

    public function getCurrentStaff(): ?string
    {
        return $this->currentStaff;
    }

    public function setCurrentStaff(?string $currentStaff): self
    {
        $this->currentStaff = $currentStaff;

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }

    public function getDepartment(): ?TCountyDepartments
    {
        return $this->department;
    }

    public function setDepartment(?TCountyDepartments $department): self
    {
        $this->department = $department;

        return $this;
    }


}
