<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TKpasRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_kpas:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_kpas:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TKpasRepository::class)
 */

class TKpas
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_kpas:read", "t_kpas:write", "t_kfas:read", "t_pc_matrix:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_kpas:read", "t_kpas:write", "t_kfas:read" })
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity=TPcMatrix::class, mappedBy="kpa")
     * @Groups({ "t_kpas:read", "t_kpas:write" })
     */
    private $tPcMatrices;

    /**
     * @ORM\OneToMany(targetEntity=TKfas::class, mappedBy="kpa")
     * @Groups({ "t_kpas:read", "t_kpas:write" })
     */
    private $tKfas;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_kpas:read", "t_kpas:write" })
     */
    private $code;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_kpas:read", "t_kpas:write" })
     */
    private $weight;

    public function __construct()
    {
        $this->tPcs = new ArrayCollection();
        $this->tPcMatrices = new ArrayCollection();
        $this->tKfas = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Collection|TPcMatrix[]
     */
    public function getTPcMatrices(): Collection
    {
        return $this->tPcMatrices;
    }

    public function addTPcMatrix(TPcMatrix $tPcMatrix): self
    {
        if (!$this->tPcMatrices->contains($tPcMatrix)) {
            $this->tPcMatrices[] = $tPcMatrix;
            $tPcMatrix->setKpa($this);
        }

        return $this;
    }

    public function removeTPcMatrix(TPcMatrix $tPcMatrix): self
    {
        if ($this->tPcMatrices->removeElement($tPcMatrix)) {
            // set the owning side to null (unless already changed)
            if ($tPcMatrix->getKpa() === $this) {
                $tPcMatrix->setKpa(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TKfas[]
     */
    public function getTKfas(): Collection
    {
        return $this->tKfas;
    }

    public function addTKfa(TKfas $tKfa): self
    {
        if (!$this->tKfas->contains($tKfa)) {
            $this->tKfas[] = $tKfa;
            $tKfa->setKpa($this);
        }

        return $this;
    }

    public function removeTKfa(TKfas $tKfa): self
    {
        if ($this->tKfas->removeElement($tKfa)) {
            // set the owning side to null (unless already changed)
            if ($tKfa->getKpa() === $this) {
                $tKfa->setKpa(null);
            }
        }

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): self
    {
        $this->code = $code;

        return $this;
    }

    public function getWeight(): ?string
    {
        return $this->weight;
    }

    public function setWeight(?string $weight): self
    {
        $this->weight = $weight;

        return $this;
    }
    
}
