<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TMilestonesRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_milestones:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_milestones:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "project": "exact", "progressStatus": "exact", "overallStatus": "exact", "departmentProject": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TMilestonesRepository::class)
 */

class TMilestones
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write", "t_county_departments_adp_projects:read" })
     */
    private $name;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $weight;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $budgetAllocated;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $startDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $endDate;

    /**
     * @ORM\ManyToOne(targetEntity=TFinancialYears::class, inversedBy="tMilestones")
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $financialYear;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $progressStatus;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tMilestones")
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $sector;

    /**
     * @ORM\ManyToOne(targetEntity=TDirectorates::class, inversedBy="tMilestones")
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $directorate;

    /**
     * @ORM\OneToMany(targetEntity=TTaskDependancies::class, mappedBy="task")
     */
    private $tTaskDependancies;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $verificationStatus;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $verificationDate;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write", "t_kfas:read", "t_county_sectors:read", "t_directorates:read", "t_projects:read" })
     */
    private $validationStatus;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $validationDate;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $overallStatus;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyDepartmentsAdpProjects::class, inversedBy="tMilestones")
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $departmentProject;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyDepartments::class, inversedBy="tMilestones")
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $department;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $indicator;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $target;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_milestones:read", "t_milestones:write" })
     */
    private $progressPercent;

    /**
     * @ORM\OneToMany(targetEntity=TMilestonesNotes::class, mappedBy="milestone")
     */
    private $tMilestonesNotes;

    public function __construct()
    {
        $this->tTaskDependancies = new ArrayCollection();
        $this->tMilestonesNotes = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getWeight(): ?string
    {
        return $this->weight;
    }

    public function setWeight(?string $weight): self
    {
        $this->weight = $weight;

        return $this;
    }

    public function getBudgetAllocated(): ?string
    {
        return $this->budgetAllocated;
    }

    public function setBudgetAllocated(?string $budgetAllocated): self
    {
        $this->budgetAllocated = $budgetAllocated;

        return $this;
    }

    public function getStartDate(): ?\DateTimeInterface
    {
        return $this->startDate;
    }

    public function setStartDate(?\DateTimeInterface $startDate): self
    {
        $this->startDate = $startDate;

        return $this;
    }

    public function getEndDate(): ?\DateTimeInterface
    {
        return $this->endDate;
    }

    public function setEndDate(?\DateTimeInterface $endDate): self
    {
        $this->endDate = $endDate;

        return $this;
    }

    public function getFinancialYear(): ?TFinancialYears
    {
        return $this->financialYear;
    }

    public function setFinancialYear(?TFinancialYears $financialYear): self
    {
        $this->financialYear = $financialYear;

        return $this;
    }

    public function getProgressStatus(): ?string
    {
        return $this->progressStatus;
    }

    public function setProgressStatus(?string $progressStatus): self
    {
        $this->progressStatus = $progressStatus;

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }

    public function getDirectorate(): ?TDirectorates
    {
        return $this->directorate;
    }

    public function setDirectorate(?TDirectorates $directorate): self
    {
        $this->directorate = $directorate;

        return $this;
    }

    /**
     * @return Collection|TTaskDependancies[]
     */
    public function getTTaskDependancies(): Collection
    {
        return $this->tTaskDependancies;
    }

    public function addTTaskDependancy(TTaskDependancies $tTaskDependancy): self
    {
        if (!$this->tTaskDependancies->contains($tTaskDependancy)) {
            $this->tTaskDependancies[] = $tTaskDependancy;
            $tTaskDependancy->setTask($this);
        }

        return $this;
    }

    public function removeTTaskDependancy(TTaskDependancies $tTaskDependancy): self
    {
        if ($this->tTaskDependancies->removeElement($tTaskDependancy)) {
            // set the owning side to null (unless already changed)
            if ($tTaskDependancy->getTask() === $this) {
                $tTaskDependancy->setTask(null);
            }
        }

        return $this;
    }

    public function getVerificationStatus(): ?string
    {
        return $this->verificationStatus;
    }

    public function setVerificationStatus(?string $verificationStatus): self
    {
        $this->verificationStatus = $verificationStatus;

        return $this;
    }

    public function getVerificationDate(): ?\DateTimeInterface
    {
        return $this->verificationDate;
    }

    public function setVerificationDate(?\DateTimeInterface $verificationDate): self
    {
        $this->verificationDate = $verificationDate;

        return $this;
    }

    public function getValidationStatus(): ?string
    {
        return $this->validationStatus;
    }

    public function setValidationStatus(?string $validationStatus): self
    {
        $this->validationStatus = $validationStatus;

        return $this;
    }

    public function getValidationDate(): ?\DateTimeInterface
    {
        return $this->validationDate;
    }

    public function setValidationDate(?\DateTimeInterface $validationDate): self
    {
        $this->validationDate = $validationDate;

        return $this;
    }

    public function getOverallStatus(): ?string
    {
        return $this->overallStatus;
    }

    public function setOverallStatus(?string $overallStatus): self
    {
        $this->overallStatus = $overallStatus;

        return $this;
    }

    public function getDepartmentProject(): ?TCountyDepartmentsAdpProjects
    {
        return $this->departmentProject;
    }

    public function setDepartmentProject(?TCountyDepartmentsAdpProjects $departmentProject): self
    {
        $this->departmentProject = $departmentProject;

        return $this;
    }

    public function getDepartment(): ?TCountyDepartments
    {
        return $this->department;
    }

    public function setDepartment(?TCountyDepartments $department): self
    {
        $this->department = $department;

        return $this;
    }

    public function getIndicator(): ?string
    {
        return $this->indicator;
    }

    public function setIndicator(?string $indicator): self
    {
        $this->indicator = $indicator;

        return $this;
    }

    public function getTarget(): ?string
    {
        return $this->target;
    }

    public function setTarget(?string $target): self
    {
        $this->target = $target;

        return $this;
    }

    public function getProgressPercent(): ?string
    {
        return $this->progressPercent;
    }

    public function setProgressPercent(?string $progressPercent): self
    {
        $this->progressPercent = $progressPercent;

        return $this;
    }

    /**
     * @return Collection|TMilestonesNotes[]
     */
    public function getTMilestonesNotes(): Collection
    {
        return $this->tMilestonesNotes;
    }

    public function addTMilestonesNote(TMilestonesNotes $tMilestonesNote): self
    {
        if (!$this->tMilestonesNotes->contains($tMilestonesNote)) {
            $this->tMilestonesNotes[] = $tMilestonesNote;
            $tMilestonesNote->setMilestone($this);
        }

        return $this;
    }

    public function removeTMilestonesNote(TMilestonesNotes $tMilestonesNote): self
    {
        if ($this->tMilestonesNotes->removeElement($tMilestonesNote)) {
            // set the owning side to null (unless already changed)
            if ($tMilestonesNote->getMilestone() === $this) {
                $tMilestonesNote->setMilestone(null);
            }
        }

        return $this;
    }
}
