<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TPcActivitiesRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_pc_activities:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_pc_activities:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "pcId": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TPcActivitiesRepository::class)
 */

class TPcActivities
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_pc_activities:read", "t_pc_activities:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_pc_activities:read", "t_pc_activities:write" })
     */
    private $activityDate;

    /**
     * @ORM\Column(type="time", nullable=true)
     * @Groups({ "t_pc_activities:read", "t_pc_activities:write" })
     */
    private $activityTime;

    /**
     * @ORM\ManyToOne(targetEntity=TWorkFlowStages::class, inversedBy="tPcActivities")
     * @Groups({ "t_pc_activities:read", "t_pc_activities:write" })
     */
    private $activityStage;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_pc_activities:read", "t_pc_activities:write" })
     */
    private $activityName;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyStaffMembers::class, inversedBy="tPcActivities")
     * @Groups({ "t_pc_activities:read", "t_pc_activities:write" })
     */
    private $activityOwner;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_pc_activities:read", "t_pc_activities:write" })
     */
    private $activityNote;

    /**
     * @ORM\ManyToOne(targetEntity=TPcs::class, inversedBy="tPcActivities")
     * @Groups({ "t_pc_activities:read", "t_pc_activities:write" })
     */
    private $pcId;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getActivityDate(): ?\DateTimeInterface
    {
        return $this->activityDate;
    }

    public function setActivityDate(?\DateTimeInterface $activityDate): self
    {
        $this->activityDate = $activityDate;

        return $this;
    }

    public function getActivityTime(): ?\DateTimeInterface
    {
        return $this->activityTime;
    }

    public function setActivityTime(?\DateTimeInterface $activityTime): self
    {
        $this->activityTime = $activityTime;

        return $this;
    }

    public function getActivityStage(): ?TWorkFlowStages
    {
        return $this->activityStage;
    }

    public function setActivityStage(?TWorkFlowStages $activityStage): self
    {
        $this->activityStage = $activityStage;

        return $this;
    }

    public function getActivityName(): ?string
    {
        return $this->activityName;
    }

    public function setActivityName(?string $activityName): self
    {
        $this->activityName = $activityName;

        return $this;
    }

    public function getActivityOwner(): ?TCountyStaffMembers
    {
        return $this->activityOwner;
    }

    public function setActivityOwner(?TCountyStaffMembers $activityOwner): self
    {
        $this->activityOwner = $activityOwner;

        return $this;
    }

    public function getActivityNote(): ?string
    {
        return $this->activityNote;
    }

    public function setActivityNote(?string $activityNote): self
    {
        $this->activityNote = $activityNote;

        return $this;
    }

    public function getPcId(): ?TPcs
    {
        return $this->pcId;
    }

    public function setPcId(?TPcs $pcId): self
    {
        $this->pcId = $pcId;

        return $this;
    }
}
