<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TProjectLocationMapsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_project_location_maps:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_project_location_maps:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TProjectLocationMapsRepository::class)
 */

class TProjectLocationMaps
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_project_location_maps:read", "t_project_location_maps:write" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyDepartmentsAdpProjects::class, inversedBy="tProjectLocationMaps")
     * @Groups({ "t_project_location_maps:read", "t_project_location_maps:write" })
     */
    private $departmentProject;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_project_location_maps:read", "t_project_location_maps:write" })
     */
    private $latitude;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_project_location_maps:read", "t_project_location_maps:write" })
     */
    private $longitude;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_project_location_maps:read", "t_project_location_maps:write" })
     */
    private $locationName;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_project_location_maps:read", "t_project_location_maps:write" })
     */
    private $projectDescription;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tProjectLocationMaps")
     * @Groups({ "t_project_location_maps:read", "t_project_location_maps:write" })
     */
    private $sector;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDepartmentProject(): ?TCountyDepartmentsAdpProjects
    {
        return $this->departmentProject;
    }

    public function setDepartmentProject(?TCountyDepartmentsAdpProjects $departmentProject): self
    {
        $this->departmentProject = $departmentProject;

        return $this;
    }

    public function getLatitude(): ?string
    {
        return $this->latitude;
    }

    public function setLatitude(?string $latitude): self
    {
        $this->latitude = $latitude;

        return $this;
    }

    public function getLongitude(): ?string
    {
        return $this->longitude;
    }

    public function setLongitude(?string $longitude): self
    {
        $this->longitude = $longitude;

        return $this;
    }

    public function getLocationName(): ?string
    {
        return $this->locationName;
    }

    public function setLocationName(?string $locationName): self
    {
        $this->locationName = $locationName;

        return $this;
    }

    public function getProjectDescription(): ?string
    {
        return $this->projectDescription;
    }

    public function setProjectDescription(?string $projectDescription): self
    {
        $this->projectDescription = $projectDescription;

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }
}
