<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TProjectsFeedbacksRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_projects_feedbacks:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_projects_feedbacks:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TProjectsFeedbacksRepository::class)
 */

class TProjectsFeedbacks
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_projects_feedbacks:read", "t_projects_feedbacks:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_projects_feedbacks:read", "t_projects_feedbacks:write" })
     */
    private $fullname;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_projects_feedbacks:read", "t_projects_feedbacks:write" })
     */
    private $contacts;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_projects_feedbacks:read", "t_projects_feedbacks:write" })
     */
    private $feedbackSubject;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_projects_feedbacks:read", "t_projects_feedbacks:write" })
     */
    private $feedbackImage;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_projects_feedbacks:read", "t_projects_feedbacks:write" })
     */
    private $feedbackDetails;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyDepartmentsAdpProjects::class, inversedBy="tProjectsFeedbacks")
     * @Groups({ "t_projects_feedbacks:read", "t_projects_feedbacks:write" })
     */
    private $project;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getFullname(): ?string
    {
        return $this->fullname;
    }

    public function setFullname(?string $fullname): self
    {
        $this->fullname = $fullname;

        return $this;
    }

    public function getContacts(): ?string
    {
        return $this->contacts;
    }

    public function setContacts(?string $contacts): self
    {
        $this->contacts = $contacts;

        return $this;
    }

    public function getFeedbackSubject(): ?string
    {
        return $this->feedbackSubject;
    }

    public function setFeedbackSubject(?string $feedbackSubject): self
    {
        $this->feedbackSubject = $feedbackSubject;

        return $this;
    }

    public function getFeedbackImage(): ?string
    {
        return $this->feedbackImage;
    }

    public function setFeedbackImage(?string $feedbackImage): self
    {
        $this->feedbackImage = $feedbackImage;

        return $this;
    }

    public function getFeedbackDetails(): ?string
    {
        return $this->feedbackDetails;
    }

    public function setFeedbackDetails(?string $feedbackDetails): self
    {
        $this->feedbackDetails = $feedbackDetails;

        return $this;
    }

    public function getProject(): ?TCountyDepartmentsAdpProjects
    {
        return $this->project;
    }

    public function setProject(?TCountyDepartmentsAdpProjects $project): self
    {
        $this->project = $project;

        return $this;
    }
}
