<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TProjectsImagesRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_projects_images:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_projects_images:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "project": "exact", "sector": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TProjectsImagesRepository::class)
 */

class TProjectsImages
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_projects_images:read", "t_projects_images:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_projects_images:read", "t_projects_images:write" })
     */
    private $imageName;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_projects_images:read", "t_projects_images:write" })
     */
    private $imageDescription;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyDepartmentsAdpProjects::class, inversedBy="tProjectsImages")
     * @Groups({ "t_projects_images:read", "t_projects_images:write" })
     */
    private $project;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tProjectsImages")
     * @Groups({ "t_projects_images:read", "t_projects_images:write" })
     */
    private $sector;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getImageName(): ?string
    {
        return $this->imageName;
    }

    public function setImageName(?string $imageName): self
    {
        $this->imageName = $imageName;

        return $this;
    }

    public function getImageDescription(): ?string
    {
        return $this->imageDescription;
    }

    public function setImageDescription(?string $imageDescription): self
    {
        $this->imageDescription = $imageDescription;

        return $this;
    }

    public function getProject(): ?TCountyDepartmentsAdpProjects
    {
        return $this->project;
    }

    public function setProject(?TCountyDepartmentsAdpProjects $project): self
    {
        $this->project = $project;

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }
}
