<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TSectorVisionAndMissionsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_sector_vision_and_missions:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_sector_vision_and_missions:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "sector": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TSectorVisionAndMissionsRepository::class)
 */

class TSectorVisionAndMissions
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_sector_vision_and_missions:read", "t_sector_vision_and_missions:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_sector_vision_and_missions:read", "t_sector_vision_and_missions:write" })
     */
    private $vision;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_sector_vision_and_missions:read", "t_sector_vision_and_missions:write" })
     */
    private $mission;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tSectorVisionAndMissions")
     * @Groups({ "t_sector_vision_and_missions:read", "t_sector_vision_and_missions:write" })
     */
    private $sector;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getVision(): ?string
    {
        return $this->vision;
    }

    public function setVision(?string $vision): self
    {
        $this->vision = $vision;

        return $this;
    }

    public function getMission(): ?string
    {
        return $this->mission;
    }

    public function setMission(?string $mission): self
    {
        $this->mission = $mission;

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }
}
