<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TStaffSalutationsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\Collection;

use Doctrine\Common\Collections\ArrayCollection;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_staff_salutations:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_staff_salutations:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "status": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TStaffSalutationsRepository::class)
 */

class TStaffSalutations
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_staff_salutations:read", "t_staff_salutations:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_staff_salutations:read", "t_staff_salutations:write", "t_county_staff_members:read" })
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({ "t_staff_salutations:read", "t_staff_salutations:write" })
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TCountyStaffMembers::class, mappedBy="staffSalutation")
     */
    private $tCountyStaffMembers;

    public function __construct()
    {
        $this->tCountyStaffMembers = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TCountyStaffMembers[]
     */
    public function getTCountyStaffMembers(): Collection
    {
        return $this->tCountyStaffMembers;
    }

    public function addTCountyStaffMember(TCountyStaffMembers $tCountyStaffMember): self
    {
        if (!$this->tCountyStaffMembers->contains($tCountyStaffMember)) {
            $this->tCountyStaffMembers[] = $tCountyStaffMember;
            $tCountyStaffMember->setStaffSalutation($this);
        }

        return $this;
    }

    public function removeTCountyStaffMember(TCountyStaffMembers $tCountyStaffMember): self
    {
        if ($this->tCountyStaffMembers->removeElement($tCountyStaffMember)) {
            // set the owning side to null (unless already changed)
            if ($tCountyStaffMember->getStaffSalutation() === $this) {
                $tCountyStaffMember->setStaffSalutation(null);
            }
        }

        return $this;
    }
    
}
