<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TTaskDependanciesRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_task_dependancies:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_task_dependancies:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TTaskDependanciesRepository::class)
 */

class TTaskDependancies
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_task_dependancies:read", "t_task_dependancies:write" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TMilestones::class, inversedBy="tTaskDependancies")
     * @Groups({ "t_task_dependancies:read", "t_task_dependancies:write" })
     */
    private $task;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tTaskDependancies")
     * @Groups({ "t_task_dependancies:read", "t_task_dependancies:write" })
     */
    private $taskOnwerSector;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tTaskDependancies")
     * @Groups({ "t_task_dependancies:read", "t_task_dependancies:write" })
     */
    private $taskDepandantSector;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_task_dependancies:read", "t_task_dependancies:write" })
     */
    private $requestNote;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_task_dependancies:read", "t_task_dependancies:write" })
     */
    private $responseNote;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTask(): ?TMilestones
    {
        return $this->task;
    }

    public function setTask(?TMilestones $task): self
    {
        $this->task = $task;

        return $this;
    }

    public function getTaskOnwerSector(): ?TCountySectors
    {
        return $this->taskOnwerSector;
    }

    public function setTaskOnwerSector(?TCountySectors $taskOnwerSector): self
    {
        $this->taskOnwerSector = $taskOnwerSector;

        return $this;
    }

    public function getTaskDepandantSector(): ?TCountySectors
    {
        return $this->taskDepandantSector;
    }

    public function setTaskDepandantSector(?TCountySectors $taskDepandantSector): self
    {
        $this->taskDepandantSector = $taskDepandantSector;

        return $this;
    }

    public function getRequestNote(): ?string
    {
        return $this->requestNote;
    }

    public function setRequestNote(?string $requestNote): self
    {
        $this->requestNote = $requestNote;

        return $this;
    }

    public function getResponseNote(): ?string
    {
        return $this->responseNote;
    }

    public function setResponseNote(?string $responseNote): self
    {
        $this->responseNote = $responseNote;

        return $this;
    }
}
