<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TWorkFlowNextStagesRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_work_flow_next_stages:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_work_flow_next_stages:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TWorkFlowNextStagesRepository::class)
 */

class TWorkFlowNextStages
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_work_flow_next_stages:read", "t_work_flow_next_stages:write", "t_work_flow_stages:read", "t_appraisals:read", "t_pcs:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({ "t_work_flow_next_stages:read", "t_work_flow_next_stages:write", "t_work_flow_stages:read", "t_appraisals:read", "t_pcs:read" })
     */
    private $nextStage;

    /**
     * @ORM\ManyToOne(targetEntity=TWorkFlowStages::class, inversedBy="tWorkFlowNextStages")
     * @Groups({ "t_work_flow_next_stages:read", "t_work_flow_next_stages:write" })
     */
    private $currentStage;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_work_flow_next_stages:read", "t_work_flow_next_stages:write", "t_work_flow_stages:read", "t_appraisals:read", "t_pcs:read" })
     */
    private $nextStageName;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNextStage(): ?int
    {
        return $this->nextStage;
    }

    public function setNextStage(?int $nextStage): self
    {
        $this->nextStage = $nextStage;

        return $this;
    }

    public function getCurrentStage(): ?TWorkFlowStages
    {
        return $this->currentStage;
    }

    public function setCurrentStage(?TWorkFlowStages $currentStage): self
    {
        $this->currentStage = $currentStage;

        return $this;
    }

    public function getNextStageName(): ?string
    {
        return $this->nextStageName;
    }

    public function setNextStageName(?string $nextStageName): self
    {
        $this->nextStageName = $nextStageName;

        return $this;
    }

}
