<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TWorkFlowStagesRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_work_flow_stages:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_work_flow_stages:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "workflow": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TWorkFlowStagesRepository::class)
 */

class TWorkFlowStages
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_work_flow_stages:read", "t_work_flow_stages:write", "t_pcs:read", "t_appraisals:read", "t_work_flow_next_stages:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_work_flow_stages:read", "t_work_flow_stages:write", "t_work_flow_next_stages:read", "t_appraisals:read" })
     */
    private $stageName;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({ "t_work_flow_stages:read", "t_work_flow_stages:write" })
     */
    private $status;

    /**
     * @ORM\ManyToOne(targetEntity=TWorkFlows::class, inversedBy="tWorkFlowStages")
     * @Groups({ "t_work_flow_stages:read", "t_work_flow_stages:write" })
     */
    private $workflow;

    /**
     * @ORM\OneToMany(targetEntity=TPcs::class, mappedBy="workflowStage")
     */
    private $tPcs;

    /**
     * @ORM\OneToMany(targetEntity=TAppraisals::class, mappedBy="workflowStage")
     */
    private $tAppraisals;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_work_flow_stages:read", "t_work_flow_stages:write" })
     */
    private $stageOwner;

    /**
     * @ORM\OneToMany(targetEntity=TWorkFlowNextStages::class, mappedBy="currentStage")
     * @Groups({ "t_work_flow_stages:read", "t_work_flow_stages:write", "t_appraisals:read", "t_pcs:read" })
     */
    private $tWorkFlowNextStages;

    /**
     * @ORM\OneToMany(targetEntity=TPcActivities::class, mappedBy="activityStage")
     */
    private $tPcActivities;

    public function __construct()
    {
        $this->tPcs = new ArrayCollection();
        $this->tAppraisals = new ArrayCollection();
        $this->tWorkFlowNextStages = new ArrayCollection();
        $this->tPcActivities = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStageName(): ?string
    {
        return $this->stageName;
    }

    public function setStageName(?string $stageName): self
    {
        $this->stageName = $stageName;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getWorkflow(): ?TWorkFlows
    {
        return $this->workflow;
    }

    public function setWorkflow(?TWorkFlows $workflow): self
    {
        $this->workflow = $workflow;

        return $this;
    }

    /**
     * @return Collection|TPcs[]
     */
    public function getTPcs(): Collection
    {
        return $this->tPcs;
    }

    public function addTPc(TPcs $tPc): self
    {
        if (!$this->tPcs->contains($tPc)) {
            $this->tPcs[] = $tPc;
            $tPc->setWorkflowStage($this);
        }

        return $this;
    }

    public function removeTPc(TPcs $tPc): self
    {
        if ($this->tPcs->removeElement($tPc)) {
            // set the owning side to null (unless already changed)
            if ($tPc->getWorkflowStage() === $this) {
                $tPc->setWorkflowStage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAppraisals[]
     */
    public function getTAppraisals(): Collection
    {
        return $this->tAppraisals;
    }

    public function addTAppraisal(TAppraisals $tAppraisal): self
    {
        if (!$this->tAppraisals->contains($tAppraisal)) {
            $this->tAppraisals[] = $tAppraisal;
            $tAppraisal->setWorkflowStage($this);
        }

        return $this;
    }

    public function removeTAppraisal(TAppraisals $tAppraisal): self
    {
        if ($this->tAppraisals->removeElement($tAppraisal)) {
            // set the owning side to null (unless already changed)
            if ($tAppraisal->getWorkflowStage() === $this) {
                $tAppraisal->setWorkflowStage(null);
            }
        }

        return $this;
    }

    public function getStageOwner(): ?string
    {
        return $this->stageOwner;
    }

    public function setStageOwner(?string $stageOwner): self
    {
        $this->stageOwner = $stageOwner;

        return $this;
    }

    /**
     * @return Collection|TWorkFlowNextStages[]
     */
    public function getTWorkFlowNextStages(): Collection
    {
        return $this->tWorkFlowNextStages;
    }

    public function addTWorkFlowNextStage(TWorkFlowNextStages $tWorkFlowNextStage): self
    {
        if (!$this->tWorkFlowNextStages->contains($tWorkFlowNextStage)) {
            $this->tWorkFlowNextStages[] = $tWorkFlowNextStage;
            $tWorkFlowNextStage->setCurrentStage($this);
        }

        return $this;
    }

    public function removeTWorkFlowNextStage(TWorkFlowNextStages $tWorkFlowNextStage): self
    {
        if ($this->tWorkFlowNextStages->removeElement($tWorkFlowNextStage)) {
            // set the owning side to null (unless already changed)
            if ($tWorkFlowNextStage->getCurrentStage() === $this) {
                $tWorkFlowNextStage->setCurrentStage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TPcActivities[]
     */
    public function getTPcActivities(): Collection
    {
        return $this->tPcActivities;
    }

    public function addTPcActivity(TPcActivities $tPcActivity): self
    {
        if (!$this->tPcActivities->contains($tPcActivity)) {
            $this->tPcActivities[] = $tPcActivity;
            $tPcActivity->setActivityStage($this);
        }

        return $this;
    }

    public function removeTPcActivity(TPcActivities $tPcActivity): self
    {
        if ($this->tPcActivities->removeElement($tPcActivity)) {
            // set the owning side to null (unless already changed)
            if ($tPcActivity->getActivityStage() === $this) {
                $tPcActivity->setActivityStage(null);
            }
        }

        return $this;
    }

}
